const bool EffectDeclaration
<
    string Name      = "Xui";
    string Class     = "Basic";
    string Fallback  = "Null";
    bool   NewMaterialUsage = true;
> = true;

texture BaseTexture          : MATERIAL_BASE_TEXTURE;
dword State_TextureWrapU     : STATE_TEXTUREWRAPU = 1;
dword State_TextureWrapV     : STATE_TEXTUREWRAPV = 1;
dword State_MinFilter        : STATE_MINFILTER = 2;
dword State_MagFilter        : STATE_MAGFILTER = 2;
dword State_MipFilter        : STATE_MIPFILTER = 2;
bool  State_AlphaBlendEnable : STATE_ALPHABLENDENABLE = true;
dword State_SrcBlend         : STATE_SRCBLEND = 1;
dword State_DstBlend         : STATE_DSTBLEND = 2;

// VS Vars
dword State_CullMode         : STATE_CULLMODE = 1;	// No culling by default
float4x4 InvViewport         : SHADERMATRIXPARAM0;	// inverse of viewport scaling matrix
float4x4 WorldViewProj       : SHADERMATRIXPARAM1;	// matWorldViewProj
float4 Params                : SHADERVECTORPARAM0;	// (0, .25, 2, 4)
float2 ShadowOffset          : SHADERVECTORPARAM1;	// textcoord offsets for dropshadow 
float4 UVTrans               : SHADERVECTORPARAM2;	// UV translation
float4x4 LocalToTexTransform : SHADERMATRIXPARAM2;	// from local coordinate system to texture uv transformation matrix

// PS Vars
float4 SolidColor  : SHADERVECTORPARAM3;
float4 ColorFactor : SHADERVECTORPARAM4;			// color to modulate with
float4 ShadowColor : SHADERVECTORPARAM5;			// color for dropshadow

struct VSOUT
{
    float4 Position : POSITION;
    float2 uvTex    : TEXCOORD0; 
    float2 uvShadow : TEXCOORD1;
};

VSOUT ShadeVertex(const float2 Position0 : POSITION0)
{
    VSOUT Output;	
    float4 pos; // position in screen space
    pos = mul(float4(Position0.x, Position0.y, 0, 1), transpose(WorldViewProj));
    pos.x -= .5;
    pos.y -= .5;
    pos.z = Params.x;

    float4 posClip; // position in clip space
    posClip = mul(pos, transpose(InvViewport));
    Output.Position = posClip;

    float4 uv = mul(float4((Position0.x), (Position0.y), 0, 1), transpose(LocalToTexTransform));
    Output.uvTex.x = uv.x + UVTrans.x;
    Output.uvTex.y = uv.y + UVTrans.y;
    Output.uvShadow = Output.uvTex;

    return Output;
}

VSOUT ShadeTextVertex(const float2 Position0 : POSITION0, const float2 uv : TEXCOORD0)
{
    VSOUT Output;

    float4 pos; // position in screen space
    pos = mul(float4(Position0.x, Position0.y, 0, 1), transpose(WorldViewProj));
    pos.z = Params.x;

    float4 posClip; // position in clip space
    posClip = mul(pos, transpose(InvViewport));
    Output.Position = posClip;

    Output.uvTex = uv;                 // texture has already been calculated
    Output.uvShadow.x = uv.x - ShadowOffset.x;
    Output.uvShadow.y = uv.y - ShadowOffset.y;

    return Output;
}

technique FixedEffect
{
    pass p0
    {
    #ifdef SHD_VERTEX
        VertexShader = compile vs_2_sw ShadeVertex();
    #endif
    #ifdef SHD_TEXTVERTEX
        VertexShader = compile vs_2_sw ShadeTextVertex();
    #endif

        PixelShader = NULL;

        NormalizeNormals = False;
        ZWriteEnable     = False;
        ZEnable          = False;
        SeparateAlphaBlendEnable = False;
        AlphaTestEnable  = False;
        StencilEnable    = False;
        FogEnable        = False;
        ColorOp[1]       = Disable;
        AlphaOp[1]       = Disable;
        CullMode         = (State_CullMode);
        AddressU[0]      = (State_TextureWrapU);
        AddressV[0]      = (State_TextureWrapV);
        MinFilter[0]     = (State_MinFilter);
        MagFilter[0]     = (State_MagFilter);
        MipFilter[0]     = (State_MipFilter);
        AlphaBlendEnable = (State_AlphaBlendEnable);
	BlendOp		 = 1; //add
        SrcBlend         = (State_SrcBlend);
        DestBlend        = (State_DstBlend);

    #ifdef SHD_SOLIDPIXEL
        //PixelShader = compile ps_2_0 ShadeSolidPixel();
        ColorArg1[0]     = Diffuse;
        ColorArg2[0]     = TFactor;
        ColorOp[0]       = SelectArg2;
        AlphaArg1[0]     = Diffuse;
        AlphaArg2[0]     = TFactor;
        AlphaOp[0]       = SelectArg2;
        TextureFactor    = (SolidColor*ColorFactor);
    #endif
    #ifdef SHD_TEXPIXEL
        //PixelShader = compile ps_2_0 ShadeTexPixel();
        Texture[0]       = (BaseTexture);
        ColorArg1[0]     = Texture;
        ColorArg2[0]     = TFactor;
        ColorOp[0]       = Modulate;
        AlphaArg1[0]     = Texture;
        AlphaArg2[0]     = TFactor;
        AlphaOp[0]       = Modulate;
        TextureFactor    = (ColorFactor);
    #endif
    #ifdef SHD_RADIALPIXEL
        //PixelShader = compile ps_2_0 ShadeRadialPixel();
        Texture[0]       = (BaseTexture);
        ColorArg1[0]     = Texture;
        ColorArg2[0]     = TFactor;
        ColorOp[0]       = Modulate;
        AlphaArg1[0]     = Texture;
        AlphaArg2[0]     = TFactor;
        AlphaOp[0]       = Modulate;
        TextureFactor    = (ColorFactor);
    #endif
    #ifdef SHD_TEXPIXEL
        //PixelShader = compile ps_2_0 ShadeTexPixel();
        Texture[0]       = (BaseTexture);
        ColorArg1[0]     = Texture;
        ColorArg2[0]     = TFactor;
        ColorOp[0]       = Modulate;
        AlphaArg1[0]     = Texture;
        AlphaArg2[0]     = TFactor;
        AlphaOp[0]       = Modulate;
        TextureFactor    = (ColorFactor);
    #endif
    #ifdef SHD_TEXTDROPSHADOWPIXEL
        //PixelShader = compile ps_2_0 ShadeTextDropShadowPixel();
        // Shadow ignored
        Texture[0]       = (BaseTexture);
        ColorArg1[0]     = Texture;
        ColorArg2[0]     = TFactor;
        ColorOp[0]       = Modulate;
        AlphaArg1[0]     = Texture;
        AlphaArg2[0]     = TFactor;
        AlphaOp[0]       = Modulate;
        TextureFactor    = (ColorFactor);
    #endif
    }
}
