// Copyright (c) Microsoft Corporation. All rights reserved.

shared Texture2D txBase : MATERIAL_BASE_TEXTURE;

shared cbuffer cbPerObject
{
    matrix g_mInvViewport         : SHADERMATRIXPARAM0;	// inverse of viewport scaling matrix
    matrix g_mWorldViewProj       : SHADERMATRIXPARAM1;	// matWorldViewProj
    float4 g_vParams              : SHADERVECTORPARAM0;	// (0, .25, 2, 4)
    float4 g_vShadowOffset        : SHADERVECTORPARAM1;	// textcoord offsets for dropshadow 
    float4 g_vUVTrans             : SHADERVECTORPARAM2;	// UV translation
    matrix g_mLocalToTexTransform : SHADERMATRIXPARAM2;	// from local coordinate system to texture uv transformation matrix
    float4 g_vSolidColor          : SHADERVECTORPARAM3;
    float4 g_vColorFactor         : SHADERVECTORPARAM4; // color to modulate with
    float4 g_vShadowColor         : SHADERVECTORPARAM5; // color for dropshadow
};

shared SamplerState samTextureSampler
<bool OverrideAddress = true;>
{
    Filter = MIN_MAG_MIP_POINT;
};