//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Global shader.  Specific for volume shadows
// Take note that this shader will take over some
// of the renderstates since they are not relevant
// to the object's base material.
//

#include <Common.fxh>
#include <FuncLibrary.fxh>
#include <MaterialDecl.fxh>

string XFile = "sjlcube.x";

const bool EffectDeclaration
<
    string Name      = "VolumeShadow";
    string Class     = "Basic";
    string Fallback  = "Shadow";
    bool   NewMaterialUsage = true;
> = true;

// Declare inputs
struct VS_INPUT
{
    float4 vPos       : POSITION;
};

// Declare outputs
struct VS_OUTPUT
{
    float4 vPos     : POSITION;
    float  fFog     : FOG;
};

// Code
VS_OUTPUT VS(const VS_INPUT v)
{
    VS_OUTPUT o = (VS_OUTPUT)0;

    // Transform to clip space
    o.vPos = mul(v.vPos, mFullProj);

	// Push the Z back a bit to reduce fighting
    o.vPos.z = o.vPos.z + 0.001f; 

    // No fog for volume shadow
    o.fFog = 1.0;

    return o;
}

float4 PS(void) : COLOR
{
    return float4(0,0,0,0.5);
}

float4 PS2(void) : COLOR
{
    return float4(1,1,1,0.5);
}

technique T0
<
    int    Performance = EffectPerfLevel_MaxShader11;
>
{
	// CCW Back Pass
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_1 PS();

        StencilEnable    = True;
        StencilFunc		 = Always;
        StencilFail		 = Keep;
        StencilPass		 = Keep;
        StencilZFail	 = Incr;
        StencilRef  	 = 0;
        StencilMask  	 = 0xFFFFFFFF; // Keep the last bit for other tasks such as old shadows
        StencilWriteMask = 0xFFFFFFFF;
        CullMode		 = Ccw;//Cw;
        AlphaBlendEnable = False;
        ColorWriteEnable = 0;//Red|Green|Blue|Alpha;
		ZFunc            = Less;
		ZWriteEnable     = (State_ZWriteEnable);
    }

	// CW Front Pass
    pass P1
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_1 PS2();

        StencilEnable    = True;
        StencilFunc		 = Always;
        StencilFail		 = Keep;
        StencilPass		 = Keep;
        StencilZFail	 = Decr;
        StencilRef  	 = 0;
        StencilMask  	 = 0xFFFFFFFF; // Keep the last bit for other tasks such as old shadows
        StencilWriteMask = 0xFFFFFFFF;
        CullMode		 = Cw;//Ccw;
        AlphaBlendEnable = False;
        ColorWriteEnable = 0;//Red|Green|Blue|Alpha;
		ZFunc            = Less;
		ZWriteEnable     = (State_ZWriteEnable);
    }
    /*
    pass P2 // Temp third pass to render the shadow
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_1 PS();

        StencilEnable    = True;
        StencilFunc		 = NotEqual;
        StencilFail		 = Keep;
        StencilPass		 = Keep;
        StencilZFail	 = Keep;
        StencilRef  	 = 0;
        StencilMask  	 = 0xFFFFFFFF; // Keep the last bit for other tasks such as old shadows
        StencilWriteMask = 0xFFFFFFFF;
        CullMode		 = None;
        AlphaBlendEnable = False;
        SrcBlend		 = SrcAlpha;
        DestBlend		 = InvSrcAlpha;
        ColorWriteEnable = Red|Green|Blue|Alpha;
        ZEnable			 = True;
        ZWriteEnable	 = False;
    }
    */
}
