//------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------

shared Texture2D txBase : MATERIAL_BASE_TEXTURE;

shared SamplerState samBaseSampler
{
    Filter = MIN_MAG_LINEAR_MIP_POINT;
    AddressU = WRAP;
    AddressV = WRAP;
};

shared cbuffer cbPerFrame
< bool bPerFrame = true; >
{
    float4  g_vEyePoint                 : VIEWPOSITION;
    float3  g_vSunVectorWorld           : SUNVECTOR_WORLDSPACE;

    //
    // Cloud lighting parameters
    //
    float   g_fMedianLine               : CLOUDMATERIAL_MEDIANLINE;
    float   g_fMinIntensity             : CLOUDMATERIAL_MININTENSITY;
    float   g_fMedianIntensity          : CLOUDMATERIAL_MEDIANINTENSITY;
    float4  g_fCloudDirectional         : CLOUDMATERIAL_DIRECTIONAL;
    float4  g_fCloudAmbient             : CLOUDMATERIAL_AMBIENT;

    //
    // Fog
    //
    float   g_fFogDensity               : FOG_DENSITY;
    float4  g_cFog                      : FOG_COLOR;
};

shared cbuffer cbPerObject
{
    matrix  g_mWorldViewProjection      : WORLDVIEWPROJECTION;
    matrix  g_mWorld                    : WORLD;

    //
    // Alpha fade in/out parameters
    //
    float   g_fAlpha                    : CLOUDMATERIAL_ALPHA;
    float   g_fAlphaEdges               : CLOUDMATERIAL_ALPHAEDGES;
    float   g_fRadius                   : CLOUDMATERIAL_RADIUS;

    //
    // Cloud coloring parameters
    //
    // REVIEW: There are a lot of parameters here being
    // set for every single cloud. Is it worth creating
    // some custom parameters and setting them once per
    // frame/material instead?
    //
    #define MAX_COLOR_LEVELS 5
    float   g_rgColorLevelHeights[MAX_COLOR_LEVELS] : CLOUDMATERIAL_COLORLEVELHEIGHTS;
    float4  g_rgColorLevelColors[MAX_COLOR_LEVELS]  : CLOUDMATERIAL_COLORLEVELCOLORS;
};

