//------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------

#include "Rain40.fxh"

struct VS_INPUT
{
    float4  vPosition : POSITION;
    float4  cColor    : COLOR0;
    float2  TexCoord  : TEXCOORD;
};

struct VS_OUTPUT
{
    float4 vPosition    : SV_POSITION;
    float4 cDiffuse     : COLOR;
    float2 TexCoord0    : TEXCOORD0;
    float2 TexCoord1    : TEXCOORD1;
};

VS_OUTPUT VS(const VS_INPUT In)
{
    VS_OUTPUT Out = (VS_OUTPUT) 0;
    Out.vPosition = mul(In.vPosition, g_mWorldViewProjection);
    Out.cDiffuse = In.cColor;
    Out.TexCoord0 = mul(In.TexCoord, g_mTextureTransforms[0]);
    Out.TexCoord1 = mul(In.TexCoord, g_mTextureTransforms[1]);
    Out.TexCoord0 += g_mTextureTransforms[0][2];
    Out.TexCoord1 += g_mTextureTransforms[1][2];
    return Out;
}

float4 PS(const VS_OUTPUT In): SV_TARGET
{
    float4 cColor0 = txTexture0.Sample(samSampler, In.TexCoord0);
    float4 cColor1 = txTexture1.Sample(samSampler, In.TexCoord1);
    return float4(1,1,1,In.cDiffuse.w) * (cColor0 + cColor1);
}

technique10 T0
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
}

