//------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------

#define MAX_CONSTANT_SET_COUNT                (30)
#define MAX_CONSTANT_CLASS_COUNT              (1*MAX_CONSTANT_SET_COUNT)

//
// Potential Textures
shared Texture2D txBase         : MATERIAL_BASE_TEXTURE;
shared Texture2D txEnvironment  : MATERIAL_ENVIRONMENT_TEXTURE;
shared Texture2D txBump[5]      : MATERIAL_WATER_BUMP_TEXTURE;


//
// Constant Buffers
shared cbuffer cbPerFrame
< bool bPerFrame = true; >
{
    float4 g_vCameraEyePoint         : VIEWPOSITION;
    float3 g_vSunVectorWorld_Sun     : LIGHTVECTOR_SUN_WORLDSPACE;
    float3 g_vSunVectorWorld_Moon    : LIGHTVECTOR_MOON_WORLDSPACE;
    float  g_fSunMoonInterpolant     : SUNMOON_INTERPOLANT;
    float3 g_vSunDirectional         : SUNCOLOR_DIRECTIONAL;
    float  g_fSimTime                : SIMTIME;

    // Fog
    float   g_fFogDensity            : FOG_DENSITY;
    float4  g_cFog                   : FOG_COLOR;
};


shared cbuffer cbPerMaterialData
< bool bPerMaterial = true; >
{
    //
    // Water Constants (Constant Data)
    float   g_fWaterConstants[MAX_CONSTANT_CLASS_COUNT] : DX10_WATER_CONSTANTS;
};

shared cbuffer cbPerMaterial
< bool bPerMaterial = true; >
{
    //
    // Water Constants (Other)
    int     g_iWaterSeason                              : DX10_WATER_SEASON;
    int     g_iWaterElevationBucket                     : DX10_WATER_ELEVATION_BUCKET;
    int     g_iWaterShowClass                           : DX10_WATER_SHOW_CLASS;
};

shared cbuffer cbPerObject
{
    matrix g_mWorld                 : WORLD;
    matrix g_mWorldViewProjection   : WORLDVIEWPROJECTION;

    // Wind Information
    float   g_fWindSpeed             : WIND_SPEED;
    float   g_fWindDirection         : WIND_DIRECTION;
    float   g_fViewElevation         : VIEW_ELEVATION;

    // HDR
    float   g_fWaterHDRScale         : DX10_HDR_WATER_SPECULAR_SCALE;
};

// 
// Samplers
shared SamplerState samClamp 
< bool OverrideFilter = true; >
{    
    AddressU = Clamp;
    AddressV = Clamp;
};

shared SamplerState samBump
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    MipLODBias = -2;
};

shared SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
