//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
#include "Water20.fxh"

const bool EffectDeclaration
<
    string Name      = "Water20BloomFX";
    string Class     = "Basic";
    string Features  = "Bump";
    string Fallback  = "Texture";
    bool   NewMaterialUsage = true;
> = true;

technique Water20BloomFX
<
    string Fallback    = "Water20FX";
    int    Performance = EffectPerfLevel_MaxShader20;
>
{
    pass p0
    {
        #include <DefaultStates.fxh>

        VertexShader = compile vs_1_1 Water20VSFX();
        PixelShader = compile ps_2_0 Water20BloomPS();
        ColorWriteEnable = Red | Green | Blue;
        ZWriteEnable     = True;
        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend         = (State_SrcBlend);
        DestBlend        = (State_DstBlend);
    }
}
