//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
#include "Water20.fxh"

const bool EffectDeclaration
<
    string Name      = "Water203D_Detail";
    string Class     = "Basic";
    string Features  = "Bump";
    string Fallback  = "Texture";
    bool   NewMaterialUsage = true;
> = true;

technique Water303D_Detail
<
    string Fallback    = "Water30";
    int    Performance = EffectPerfLevel_MaxShader30;
>
{
    pass p0
    {
        #include <DefaultStates.fxh>

        VertexShader = compile vs_3_0 Water20VSNoFX3D_Detail();
        PixelShader = compile ps_3_0 Water30PSNoFX3D_Detail();
        ColorWriteEnable = Red | Green | Blue;
        ZWriteEnable     = True;
        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend         = (State_SrcBlend);
        DestBlend        = (State_DstBlend);
    }
}

technique Water203D_Detail
<
    string Fallback    = "Water20";
    int    Performance = EffectPerfLevel_MaxShader20;
>
{
    pass p0
    {
        #include <DefaultStates.fxh>

        VertexShader = compile vs_1_1 Water20VSNoFX3D_Detail();
        PixelShader = compile ps_2_0 Water20PSNoFX3D_Detail();
        ColorWriteEnable = Red | Green | Blue;
        ZWriteEnable     = True;
        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend         = (State_SrcBlend);
        DestBlend        = (State_DstBlend);
    }
}
