//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
#include "Water20.fxh"

const bool EffectDeclaration
<
    string Name      = "Water203D_Copy";
    string Class     = "Basic";
    string Features  = "Bump";
    string Fallback  = "Texture";
    bool   NewMaterialUsage = true;
> = true;

float4 WaterCopy
    (
    in float2 vScreenPosition : TEXCOORD0
    ) : COLOR
{
    return tex3D( Water_BaseSampler, float3(vScreenPosition.xy, ShaderFloatParam0) );
}

technique Water20FX3DCopy
<
    string Fallback    = "Water20";
    int    Performance = EffectPerfLevel_MaxShader20;
>
{
    pass p0
    {
        #include <DefaultStates.fxh>

        PixelShader = compile ps_2_0 WaterCopy();
    }
}
