//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include "Terrain.fxh"

const bool EffectDeclaration
<
    string Name      = "TerrainLandWaterLandDetailBump";
    string Class     = "Terrain";
    string Fallback  = "TerrainLandWaterLandDetailReflect";
> = true;

technique T0
<
>
{
    pass p0
    {
        #include <DefaultStates.fxh>

        VertexShader = compile vs_1_1 TerrainBumpVS(true);
        PixelShader  = asm {
            ps_1_1

            def c0, 0, 0, 0, 0
        
            tex t0
            texbeml t1, t0 // t1 = env
            tex t2         // t2 = base  
            tex t3         // t3 = detail

            // (Base * Detail) * 2 + (Env.a * Env)
            mul_x2 r0.rgb, t2, t3
            +mov r0.a, t2.a

            // Select land detail or water only
            cnd r0.rgb, r0.a, r0, t2

            // If alpha of texture 2 is 0, we apply the environment map
            +mul r1.a, t1.a, 1-t2.a
            mad_sat r0.rgb, t1, r1.a, r0
            +mov r0.a, c0.a
        };


        Texture[0]       = (BumpTexture);
        AddressU[0]      = Wrap;
        AddressV[0]      = Wrap;
        MinFilter[0]     = (State_MinFilter);
        MagFilter[0]     = (State_MagFilter);
        MipFilter[0]     = Linear;
        MipMapLodBias[0] = (State_MipMapLodBias);

        Texture[1]       = (EnvTexture);
        AddressU[1]      = Clamp;
        AddressV[1]      = Clamp;
        MinFilter[1]     = (State_MinFilter);
        MagFilter[1]     = (State_MagFilter);
        MipFilter[1]     = (State_MipFilter);
        MipMapLodBias[1] = (State_MipMapLodBias);

        Texture[2]       = (BaseTexture);
        AddressU[2]      = Clamp;
        AddressV[2]      = Clamp;
        MinFilter[2]     = (State_MinFilter);
        MagFilter[2]     = (State_MagFilter);
        MipFilter[2]     = (State_MipFilter);
        MipMapLodBias[2] = (State_MipMapLodBias);

        Texture[3]       = (LandDetailTexture);
        AddressU[3]      = Wrap;
        AddressV[3]      = Wrap;
        MinFilter[3]     = (State_MinFilter);
        MagFilter[3]     = (State_MagFilter);
        MipFilter[3]     = (State_MipFilter);
        MipMapLodBias[3] = (State_MipMapLodBias);

        TexCoordIndex[0] = 0;
        TexCoordIndex[1] = 1;
        TexCoordIndex[2] = 2;
        TexCoordIndex[3] = 3;

        TextureTransformFlags[0] = Disable;
        TextureTransformFlags[1] = Disable;
        TextureTransformFlags[2] = Disable;

        ColorWriteEnable = Red | Green | Blue | Alpha;
    }
}
