//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include "Terrain.fxh"

const bool EffectDeclaration
<
    string Name      = "TerrainCopy";
    string Class     = "Terrain";
    string Fallback  = "TextureCopy";
> = true;

technique T0
<
>
{
    pass p0
    {
        #include <DefaultStates.fxh>
        VertexShader = compile vs_1_1 TerrainVS(false, false, false, false);
        PixelShader  = compile ps_1_1 TerrainPS(true,  false, false, false, false, false);
        ColorWriteEnable = Red | Green | Blue | Alpha;
    }
}

technique T1
<
    string Features    = "FixedFunction";
>
{
    pass P0
    {        
        #include <OneStageDefault.fxh>
        Texture[0]   = (BaseTexture);

        ColorOp[0]   = SelectArg1;
        AlphaOp[0]   = SelectArg1;
        ColorArg1[0] = Texture;
        AlphaArg1[0] = Texture;

        AddressU[0]  = Clamp;
        AddressV[0]  = Clamp;

        AlphaBlendEnable = False;
    }
}
