//------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.
//------------------------------------------------------------------------------

// Potential textures
shared Texture2D txBase        : MATERIAL_BASE_TEXTURE;
shared Texture2D txLandDetail  : MATERIAL_LAND_DETAIL_TEXTURE;
shared Texture2D txWaterDetail : MATERIAL_WATER_DETAIL_TEXTURE;
shared Texture2D txEnvironment : MATERIAL_ENVIRONMENT_TEXTURE;
shared Texture2D txBump        : MATERIAL_BUMP_TEXTURE;

shared SamplerState samWrap
< bool OverrideFilter = true; >
{    
    AddressU = Wrap;
    AddressV = Wrap;
};

shared SamplerState samClamp 
< bool OverrideFilter = true; >
{    
    AddressU = Clamp;
    AddressV = Clamp;
};


shared cbuffer cbPerFrame
< bool bPerFrame = true; >
{
    float4 g_vCameraEyePoint        : VIEWPOSITION;
    float3 g_vSunVectorWorld        : SUNVECTOR_WORLDSPACE;
    float3 g_vSunDirectional        : SUNCOLOR_DIRECTIONAL;
    float3 g_vSunAmbient            : SUNCOLOR_AMBIENT;
    
    // Fog
    float g_fFogDensity             : FOG_DENSITY;
    float4 g_cFog                   : FOG_COLOR;
};

shared cbuffer cbPerObject
{  
    matrix g_mEnvrionment           : WATERENVMATRIX;
    float g_fLandDetailScale        : MATERIAL_LAND_DETAIL_SCALE;
    float g_fWaterDetailScale       : MATERIAL_WATER_DETAIL_SCALE;
    float g_fBumpScale              : MATERIAL_BUMP_SCALE;
    matrix g_mWorld                 : WORLD;
    matrix g_mWorldViewProjection   : WORLDVIEWPROJECTION;
};
