//-----------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation. All Rights Reserved
//-----------------------------------------------------------------------------

#include "Quad.sh"

#ifndef GSQUAD_EMIT_TEXCOORD
cbuffer GsQuadCb
{
    float4 fillColor;
    float  fillDepth;
};
#endif

// Normalized viewport coordinates.
static const float2 pos[4] = {
    float2(-1.0,-1.0),
    float2( 1.0,-1.0),
    float2(-1.0, 1.0),
    float2( 1.0, 1.0)
};

#ifdef GSQUAD_EMIT_TEXCOORD
// Normalized texture coordinates. 
static const float2 tex[4] = {
    float2(0.0,1.0),
    float2(1.0,1.0),
    float2(0.0,0.0),
    float2(1.0,0.0)
};
#endif

//
// Generates a four vertex triangle strip that draws a quad
// over the entire viewport.
// 
[MaxVertexCount(4)] void 
GsQuadMain(
   point GsQuad                 input[1],
   inout TriangleStream<PsQuad> strip
   )
{
    PsQuad vert;
    #ifndef GSQUAD_EMIT_TEXCOORD
    vert.color = fillColor;
    #endif
    
    // Generate the four vertices.
    for (int idx = 0; idx < 4; ++idx)
    {
        #ifdef GSQUAD_EMIT_TEXCOORD
        vert.position = float4(pos[idx].x,pos[idx].y,1.0,1.0);
        vert.texcoord = tex[idx];
        #else
        vert.position = float4(pos[idx].x,pos[idx].y,fillDepth,1.0);
        #endif
        strip.Append(vert);
    }
    strip.RestartStrip();
} 
