//---------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation. All rights reserved
//---------------------------------------------------------------------------
//
// Wireframe effect file.
//

const bool EffectDeclaration
<
    string Name     = "WireFrameD3D10";
    string Class    = "Global";
    string Features = "DrawWireFrame";
> = true;

// Transform constant buffer
cbuffer FsTransforms
{
    matrix<float,4,4> mWorld;
    matrix<float,4,4> mWorldView;
    matrix<float,4,4> mWorldInv;
    matrix<float,4,4> mView;
    matrix<float,4,4> mProjection;
    matrix<float,4,4> mFullProj;
}

// Vertex shader input
struct VsInWf
{
    vector<float,4> position : SV_Position;
};

// Vertex shader to pixel shader
struct Vs2PsWf
{
    vector<float,4> position : SV_Position;
};

// Wire frame vertex shader
Vs2PsWf
VsWireFrame(VsInWf inVert)
{
    Vs2PsWf outVert;

    // Transform the vertex to homogeneous clip space.
    outVert.position = mul(inVert.position,mFullProj);
    return outVert;
}

// Wire frame pixel shader
vector<float,4> 
PsWireFrame(Vs2PsWf inPixel) : COLOR
{
    return vector<float,4>(1.0,1.0,1.0,1.0);
}

RasterizerState rsWireFrame
{
    FILLMODE                = WIREFRAME;
    FRONTCOUNTERCLOCKWISE   = TRUE;
    SCISSORENABLE           = TRUE;
};

technique10 DrawWireFrame
{
    pass P0
    {
        // Set state objects.
        SetRasterizerState(rsWireFrame);
        
        // Set shaders.
        SetVertexShader(CompileShader(vs_4_0,VsWireFrame()));
        SetGeometryShader(0);
        SetPixelShader(CompileShader(ps_4_0,PsWireFrame()));
    }
}
