//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Global shader.  Handles all cases
//

#include <Common.fxh>
#include <FuncLibrary.fxh>
#include <MaterialDecl.fxh>

string XFile = "sjlcube.x";

const bool EffectDeclaration
<
    string Name      = "GeneralShadow";
    string Class     = "Basic";
    string Fallback  = "ShadowXYZCUV";
    bool   NewMaterialUsage = true;
> = true;

// Declare inputs
struct VS_INPUT
{
    float4 vPos           : POSITION;
    float4 vBlendWeight   : BLENDWEIGHT;
    float4 vBlendIndices  : BLENDINDICES;
};

// Declare outputs
struct VS_OUTPUT
{
    float4 vPos     : POSITION;
    float  fFog     : FOG;
};

// Code
VS_OUTPUT
VS(const VS_INPUT v)
{
    float4 vPos = v.vPos;;
    VS_OUTPUT o = (VS_OUTPUT)0;

    // Convert D3DCOLOR to UBYTE4. We can't use UBYTE4 types directly because
    // most 1.x shader hardware does not support it. As a sollution, we use
    // D3DCOLOR and use the D3DCOLORtoUBYTE4 macro to tweak the values back.
    float4 vBlendWeight = D3DCOLORtoUBYTE4(v.vBlendWeight) / 255.0f;
    float4 vBlendIndices = D3DCOLORtoUBYTE4(v.vBlendIndices);

    // Apply skinning on position
    vPos = SkinPosition(vPos,vBlendWeight,vBlendIndices);

    // Transform to clip space
    o.vPos = mul(vPos, mFullProj);

    // Compute fog
    o.fFog = ComputeFog(o.vPos.w);

    return o;
}

float4
PS(void) : COLOR
{
    return (float4(0, 0, 0, 0.5));
}

technique T0
<
    int    Performance = EffectPerfLevel_MaxShader11;
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_1 PS();

        StencilEnable    = (State_StencilEnable);
        StencilFunc      = NotEqual;
        StencilRef       = 0x01;
        StencilMask      = 0xffffffff;
        StencilWriteMask = 0xffffffff;
        StencilZFail     = Keep;
        StencilFail      = Keep;
        StencilPass      = Replace;

        AlphaBlendEnable = (State_ShadowAlphaBlendEnable);
        SrcBlend	     = SrcAlpha;
        DestBlend	     = InvSrcAlpha;
		ZEnable			 = True;

    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        ColorArg1[0]             = TFactor;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = TFactor;
        AlphaOp[0]               = SelectArg1;

        TextureFactor    = 0x80000000;
        AlphaBlendEnable = True;
		ZEnable			 = True;
		SrcBlend		 = SrcAlpha;
		DestBlend	     = InvSrcAlpha;
    }
}
