//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Global shadowmap shader.
//

#include <Common.fxh>
#include <FuncLibrary.fxh>
#include <MaterialDecl.fxh>

string XFile = "sjlcube.x";

const bool EffectDeclaration
<
    string Name      = "GeneralShadowMap";
    string Class     = "Basic";
    string Fallback  = "General";
    bool   NewMaterialUsage = true;
> = true;

// Declare inputs
struct VS_INPUT
{
    float4 vPos       : POSITION;

#ifdef SHD_SKIN
    float4 vBlendWeight  : BLENDWEIGHT;
    float4 vBlendIndices : BLENDINDICES;
#endif
};

// Declare outputs
struct VS_OUTPUT
{
    float4 vPos     : POSITION;
    float  fDepth   : TEXCOORD0;
};

// Code
VS_OUTPUT
VS(const VS_INPUT v)
{
    VS_OUTPUT o = (VS_OUTPUT)0;

    float4 vPos;

    #ifdef SHD_SKIN
    {
        // Convert D3DCOLOR to UBYTE4. We can't use UBYTE4 types directly because
        // most 1.x shader hardware does not support it. As a sollution, we use
        // D3DCOLOR and use the D3DCOLORtoUBYTE4 macro to tweak the values back.
        float4 vBlendWeight = D3DCOLORtoUBYTE4(v.vBlendWeight) / 255.0f;
        float4 vBlendIndices = D3DCOLORtoUBYTE4(v.vBlendIndices);

        // Apply skinning on position
        vPos = SkinPosition(v.vPos,vBlendWeight,vBlendIndices);
    }
    #else
    {
        vPos = v.vPos;
    }
    #endif

    // Transform to clip space
    o.vPos = mul(vPos, mFullProj);
    o.fDepth = o.vPos.z;

    return o;
}

float4
PS(float fDepth:TEXCOORD0) : COLOR
{
    return float4(fDepth, 0, 0, 1);
}

technique ShadowMap
<
    int    Performance = EffectPerfLevel_MaxShader20;
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        VertexShader = compile vs_2_0 VS();
        PixelShader  = compile ps_2_0 PS();

        AlphaBlendEnable = (State_ShadowAlphaBlendEnable);
        SrcBlend	     = SrcAlpha;
        DestBlend	     = InvSrcAlpha;
		ZEnable			 = True;
		CullMode         = None;
    }
}
