// Copyright (c) Microsoft Corporation. All rights reserved.

#define MAX_BONES        22

shared cbuffer cbPerFrame
< bool bPerFrame = true; >
{
    matrix  g_mDeviceToViewport     : DEVICETOVIEWPORT;
    float4  g_vCameraEyePoint       : VIEWPOSITION;
    float   g_fFogDensity           : FOG_DENSITY;
    float4  g_cFog                  : FOG_COLOR;
};

shared cbuffer cbPerObject
{    
    matrix    g_mWorldViewProjection    : WORLDVIEWPROJECTION;
    matrix    g_mWorld                  : WORLD;
    matrix    g_mWorldView              : WORLDVIEW;
};

// HACK -shanond split this out since it probably won't be updated for
// 	non-shadows objects
shared cbuffer cbPerShadowObject
{
    matrix    g_mShadowMtx              : SHADOWPROJECTION;
    matrix    g_mShadowViewMtx          : SHADOWVIEW;
    float3    g_vShadowOffset           : SHADOWOFFSET;
    float     g_fShadowRange            : SHADOWRANGE;
    float     g_fShadowKickIn           : SHADOWKICKIN;
    float     g_fShadowIntensity        : SHADOWINTENSITY;
    float     g_fShadowBias             : SHADOWBIAS;
};

// HACK -shanond (split this out too)
shared cbuffer cbPerSkinnedObject
{
    float4x3  g_rgmBones[MAX_BONES]     : BONE_MATRIX;
};

