// Copyright (c) Microsoft Corporation. All rights reserved.

#define MAX_POINT_LIGHTS 5
#define MAX_BONES        22

//
// Textures
shared Texture2D txBase              : MATERIAL_BASE_TEXTURE;
shared TextureCube txEnvironment     : MATERIAL_ENVIRONMENT_TEXTURE_CUBE;
shared Texture2D txBump              : MATERIAL_BUMP_TEXTURE;
shared Texture2D txDetail            : MATERIAL_DETAIL_TEXTURE;
shared Texture2D txSpecular          : MATERIAL_SPECULAR_TEXTURE;
shared Texture2D txEmissive          : MATERIAL_EMISSIVE_TEXTURE;
shared Texture2D txFresnel           : MATERIAL_FRESNEL_RAMP;
shared Texture2D txShadowMap         : MATERIAL_SHADOW_MAP;

//
// Sampler States
//

// Used for Base, Detail, Specular, Emissive & Shadows
shared SamplerState samDefaultOverrides
< bool OverrideFilter = true;
  bool OverrideAddress = true;>
{
    // Use Reasonable Defaults
};

shared SamplerState samBump
< bool OverrideAddress = true; >
{
    Filter = MIN_MAG_MIP_LINEAR;
};

shared SamplerState samFresnel
< bool OverrideFilter = true; >
{
    AddressU = Clamp;
    AddressV = Clamp;
};

shared SamplerState samEnvironment
< bool OverrideFilter = true; >
{
    AddressU = Clamp;
    AddressV = Clamp;
    AddressW = Clamp;
};

shared SamplerState shadowMapSampler
{
    AddressU      = Clamp;
    AddressV      = Clamp;
    Filter        = MIN_MAG_MIP_POINT;
};

shared cbuffer cbPerFrame
< bool bPerFrame = true; >
{
    matrix  g_mProjection            : PROJECTION;
    matrix  g_mDeviceToViewport      : DEVICETOVIEWPORT;
    float4  g_vEyePoint              : VIEWPOSITION;
    float3  g_vSunVectorWorld        : SUNVECTOR_WORLDSPACE;
    float3  g_vSunVectorWorld_Sun    : LIGHTVECTOR_SUN_WORLDSPACE;
    float3  g_vSunVectorWorld_Moon   : LIGHTVECTOR_MOON_WORLDSPACE;
    float3  g_vSunAmbient            : SUNCOLOR_AMBIENT;
    float3  g_vSunDirectional        : SUNCOLOR_DIRECTIONAL;
    float   g_fSunMoonInterpolant    : SUNMOON_INTERPOLANT;
    float   g_fSimTime               : SIMTIME;
    float   g_fBlendedEmissiveFactor : STATE_BLENDEDEMISSIVEFACTOR;
    float4  g_cFog                   : FOG_COLOR;
};

shared cbuffer cbPerMaterial
< bool bPerMaterial = true; >
{
    float   g_fBumpScale             : MATERIAL_BUMP_SCALE;
    float   g_fDetailScale           : MATERIAL_DETAIL_SCALE;
    float   g_fEnvironmentLevelScale : MATERIAL_ENVIRONMENT_LEVEL_SCALE;
    float   g_fSpecularMapPowerScale : MATERIAL_SPECULAR_MAP_POWER_SCALE;
    float4  g_cSpecular              : MATERIAL_SPECULAR;
    float4  g_fDiffuse               : MATERIAL_DIFFUSE;
    float   g_fFinalAlphaBlendFactor : STATE_FINALALPHABLENDFACTOR;
    float   g_fAlphaTestThreshold    : STATE_ALPHATESTTHRESHOLD;
    float4  g_fPrecipConstants       : MATERIAL_CONSTANTS;
    float   g_fFogDensity            : FOG_DENSITY;
};

// Transferring related values as part of a vector is cheaper
// than transferring them as separate semantics.
#define g_fMaterialPrecipOffset (g_fPrecipConstants.y)
#define g_fMaterialPrecipLevel  (g_fPrecipConstants.x)

// General
shared cbuffer cbGeneral
{
    matrix    g_mWorldViewProjection : WORLDVIEWPROJECTION;
    matrix    g_mWorld               : WORLD;
    dword     g_vFallbackColor       : FALLBACKCOLOR;
};

// Shadows
shared cbuffer cbShadows
{
    matrix    g_mShadow              : SHADOWPROJECTION;
    matrix    g_mShadowView          : SHADOWVIEW;
    float3    g_vShadowOffset        : SHADOWOFFSET;
    float     g_fShadowRange         : SHADOWRANGE;
    float     g_fShadowKickIn        : SHADOWKICKIN;
    float     g_fShadowIntensity     : SHADOWINTENSITY;
    float     g_fShadowBias          : SHADOWBIAS;
    float     g_fShadowSize          : SHADOWSIZE;
};

// Lights
shared cbuffer cbLighting
{
    float4  g_vPointLightWorldSpace[MAX_POINT_LIGHTS]       : POINTLIGHTVECTOR_WORLDSPACE;
    float4  g_vPointLightDiffuse[MAX_POINT_LIGHTS]          : POINTLIGHTCOLOR_DIFFUSE;
    float4  g_vPointLightSpecular[MAX_POINT_LIGHTS]         : POINTLIGHTCOLOR_SPECULAR;
    float4  g_vPointLightRangeAttenuation[MAX_POINT_LIGHTS] : POINTLIGHTVECTOR_RANGE_ATTENUATION;
    int     g_iPointLightCount                              : POINTLIGHT_COUNT;
};

// Bones
shared cbuffer cbBones
{
    float4x3 g_rgmBones[MAX_BONES]  : BONE_MATRIX;
};


#ifdef SHD_DEBUG

    shared cbuffer cbHdrDebugConstants
    < bool bPerFrame = true; >
    {
        float fHdrSpecularScale : DX10_HDR_SPECULAR_SCALE;
        float fHdrEmissiveScale : DX10_HDR_EMISSIVE_SCALE;
        float fHdrCopyScale     : DX10_HDR_COPY_SCALE;
        float fHdrModAlphaScale : DX10_HDR_MOD_ALPHA_SCALE;
    };

#else

    static const float fHdrSpecularScale = 1.11;
    static const float fHdrEmissiveScale = 6.0;
    static const float fHdrCopyScale     = 4.25;
    static const float fHdrModAlphaScale = 3.92;

#endif


