//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Fallbacks when textures are missing
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "TextureFallbackNoDiffuse";
    string Class     = "Basic";
    string Features  = "FixedFunction";
> = true;

dword  FallbackColor : FALLBACKCOLOR;

technique T0
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        ColorArg1[0]             = TFactor;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = TFactor;
        AlphaOp[0]               = SelectArg1;

        TextureFactor    = (FallbackColor);
        AlphaBlendEnable = (State_FallbackAlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        ColorArg1[1]             = Diffuse;
        ColorOp[0]               = SelectArg2;
        AlphaArg1[1]             = Diffuse;
        AlphaOp[0]               = SelectArg2;

        TextureFactor    = (FallbackColor);
        AlphaBlendEnable = (State_FallbackAlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}

