//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "TextureDetailAlpha";
    string Class     = "Basic";
    string Features  = "FixedFunction, Detail";
    string Fallback  = "TextureAlpha";
> = true;

texture BaseTexture : TEXTURE0
<
    string name = "lake.bmp";
>;

texture DetailTexture : TEXTURE1
<
    string name = "lake.bmp";
>;

matrix mDetail        : DETAILMATRIX;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        Texture[1]               = (DetailTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Modulate2x;
        AlphaArg2[0]             = Current;
        AlphaOp[1]               = SelectArg2;

        TexCoordIndex[1]         = 0;
        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mDetail);

        AlphaBlendEnable = True;
        SrcBlend         = SrcAlpha;
        DestBlend        = InvSrcAlpha;
    }
}
