//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture with alpha
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "TextureCopyAlpha";
    string Class     = "Basic";
    string Features  = "FixedFunction";
> = true;

texture BaseTexture : TEXTURE0
<
    string name = "lake.bmp";
>;

technique T0
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        AlphaBlendEnable = (State_TextureAlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;

        AlphaTestEnable  = (State_TextureAlphaBlendEnable);
        AlphaFunc        = NotEqual;
        AlphaRef         = 0x00;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        AlphaBlendEnable = (State_TextureAlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}


