//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "TextureAlphaDetailBlendTFactor";
    string Class     = "Basic";
    string Features  = "FixedFunction, Detail";
    string Fallback  = "TextureBlendTFactor";
> = true;

texture BaseTexture : TEXTURE0
<
    string name = "lake.bmp";
>;

texture DetailTexture : TEXTURE1
<
    string name = "lake.bmp";
>;

matrix mDetail        : DETAILMATRIX;

technique T0
<
>
{
    pass P0
    {
        #include <ThreeStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        Texture[1]               = (DetailTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Modulate2x;
        AlphaArg2[1]             = Current;
        AlphaOp[1]               = SelectArg2;

        ColorArg1[2]             = Current;
        ColorArg2[2]             = TFactor;
        ColorOp[2]               = Modulate;
        AlphaArg1[2]             = Current;
        AlphaOp[2]               = SelectArg1;

        TextureFactor            = (ShaderParam1);

        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mDetail);

        AlphaBlendEnable = True;
        SrcBlend         = SrcAlpha;
        DestBlend        = InvSrcAlpha;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        ColorArg1[1]             = Current;
        ColorArg2[1]             = TFactor;
        ColorOp[1]               = Modulate;
        AlphaArg1[1]             = Current;
        AlphaArg2[1]             = TFactor;
        AlphaOp[1]               = Modulate;

        TextureFactor    = (ShaderParam1);
        AlphaBlendEnable = False;
    }
}


