//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Alpha blend the texture, adding the alpha component
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "TextureAlphaAccumulate";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "TextureAlpha";
> = true;

texture BaseTexture : TEXTURE0
<
    string name = "lake.bmp";
>;

technique T0
<
    string WorkArounds = "UsesSeparateAlphaBlendEnable";
>
{
    // Use seperable alpha blend to add the alpha component
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        
        ColorArg1[0]             = Diffuse;
        ColorArg2[0]             = Texture;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        ZWriteEnable     = False;
        SeparateAlphaBlendEnable = True;
        AlphaBlendEnable = True;

        SrcBlend	  = SrcAlpha;
        DestBlend	  = InvSrcAlpha;
        SrcBlendAlpha = One;
        DestBlendAlpha	  = One;
    }
}

technique T1
<
>
{
    // Use two passes
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Diffuse;
        ColorArg2[0]             = Texture;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        ColorWriteEnable = Red | Green | Blue;
        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }

    pass P1
    {
        Texture[0]               = (BaseTexture);
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = SelectArg2;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        ColorWriteEnable = Alpha;
        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend	 = One;
        DestBlend	 = One;
    }
}
