//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Shadow shader for XYZCUV vertex geometries
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "ShadowVolXYZCUV";
    string Class     = "Basic";
    string Features  = "FixedFunction";
> = true;

technique T0
<
    int    Performance = EffectPerfLevel_MaxShader11;
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        ColorArg1[0]             = TFactor;
        ColorArg2[0]             = TFactor;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = TFactor;
        AlphaArg2[0]             = TFactor;
        AlphaOp[0]               = SelectArg1;
        
        TextureFactor    = 0x80000000;
        StencilEnable    = (State_StencilEnable);
        AlphaBlendEnable = (State_ShadowAlphaBlendEnable);
        StencilFunc      = NotEqual;
        StencilRef       = 0x01;
        StencilMask      = 0xffffffff;
        StencilWriteMask = 0x00000001;
        StencilZFail     = Keep;
        StencilFail      = Keep;
        StencilPass      = Replace;
        SrcBlend		 = SrcAlpha;
        DestBlend	     = InvSrcAlpha;
        ColorWriteEnable = 0;//Red | Green | Blue | Alpha;
    }
}

