//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Shadow
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "ShadowVol";
    string Class     = "Basic";
    string Features  = "FixedFunction";
> = true;

technique Shadow
<
    int    Performance = EffectPerfLevel_MaxShader11;
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        ColorOp[0]               = Disable;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = SelectArg2;

        StencilEnable    = (State_StencilEnable);
        AlphaBlendEnable = (State_ShadowAlphaBlendEnable);
        StencilFunc      = NotEqual;
        StencilRef       = 0x01;
        StencilMask      = 0xffffffff;
        StencilWriteMask = 0x00000001;
        StencilZFail     = Keep;
        StencilFail      = Keep;
        StencilPass      = Replace;
        SrcBlend		 = SrcAlpha;
        DestBlend	     = InvSrcAlpha;
        ColorWriteEnable = 0;
    }
}
