//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Rain
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "Rain";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "TextureAlpha";
> = true;

texture BaseTexture  : TEXTURE0;
texture BaseTexture2 : TEXTURE1;

matrix mTexture[2] : RAINMATERIAL_TEXTUREMATRICES;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>
        
        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate2X;
    
        AddressU[0]              = Wrap;
        AddressV[0]              = Wrap;
        TextureTransformFlags[0] = Count2;
        TextureTransform[0]      = (mTexture[0]);

        Texture[1]               = (BaseTexture2);
        ColorArg0[1]             = Current;
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Diffuse;
        ColorOp[1]               = MultiplyAdd;
        AlphaArg0[1]             = Current;
        AlphaArg1[1]             = Texture;
        AlphaArg2[1]             = Diffuse;
        AlphaOp[1]               = MultiplyAdd;

        AddressU[1]              = Wrap;
        AddressV[1]              = Wrap;
        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mTexture[1]);

        ZWriteEnable     = False;
	    ZEnable	 	     = False;
        AlphaTestEnable  = True;
        AlphaFunc        = Greater;
        AlphaRef         = 0x04;
        AlphaBlendEnable = True;
        SrcBlend         = SrcAlpha;
        DestBlend        = InvSrcAlpha;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate2X;

        AddressU[0]              = Wrap;
        AddressV[0]              = Wrap;
        TextureTransformFlags[0] = Count2;
        TextureTransform[0]      = (mTexture[0]);

        ZWriteEnable     = False;
	ZEnable	 	 = False;
        AlphaTestEnable  = True;
        AlphaFunc        = Greater;
        AlphaRef         = 0x04;
        AlphaBlendEnable = True;
        SrcBlend         = SrcAlpha;
        DestBlend        = InvSrcAlpha;
    }
}
