//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>
#include <MaterialDecl.fxh>

const bool EffectDeclaration
<
    string Name      = "GF_TextureDetail";
    string Class     = "Basic";
    string Features  = "FixedFunction, Detail";
    bool   NewMaterialUsage = true;
> = true;

matrix mDetail        : DETAILMATRIX;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = Disable;

        Texture[1]               = (DetailTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Modulate2x;
        AlphaOp[1]               = Disable;

        TexCoordIndex[1]         = 0;
        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mDetail);

        AlphaBlendEnable = False;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = Disable;

        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mDetail);

        AlphaBlendEnable = False;
    }

    pass P1
    {
        Texture[0]               = (DetailTexture);
        ColorArg1[0]             = Texture;
        ColorOp[0]               = SelectArg1;
        AlphaOp[0]               = Disable;

        AddressU[0]              = Wrap;
        AddressV[0]              = Wrap;
        TextureTransformFlags[0] = Count2;
        TextureTransform[0]      = (mDetail);

        AlphaBlendEnable = True;
        SrcBlend         = DestColor;
        DestBlend        = SrcColor;
    }
}


