//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>
#include <MaterialDecl.fxh>

const bool EffectDeclaration
<
    string Name      = "GF_TextureColorKey";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    bool   NewMaterialUsage = true;
> = true;

technique T0
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        AlphaTestEnable  = True;
        AlphaFunc        = GreaterEqual;
        AlphaRef         = 0xB0;
        AlphaBlendEnable = False;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        AlphaTestEnable  = True;
        AlphaFunc        = Equal;
        AlphaRef         = 0xFF;
        AlphaBlendEnable = False;
    }
}

technique T2
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        AlphaTestEnable  = True;
        AlphaFunc        = NotEqual;
        AlphaRef         = 0x00;
        AlphaBlendEnable = False;
    }
}

technique T3
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}


