//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Texture with TFactor
//

#include <Common.fxh>
#include <MaterialDecl.fxh>

const bool EffectDeclaration
<
    string Name      = "GF_TextureAlphaBlendTFactor";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "GF_TextureBlendTFactor";
    bool   NewMaterialUsage = true;
> = true;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = Modulate;

        ColorArg1[1]             = Current;
        ColorArg2[1]             = TFactor;
        ColorOp[1]               = Modulate;
        AlphaArg1[1]             = Current;
        AlphaArg2[1]             = TFactor;
        AlphaOp[1]               = Modulate;

        TextureFactor    = (ShaderParam0);

        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        ColorArg1[1]             = Current;
        ColorArg2[1]             = TFactor;
        ColorOp[1]               = Modulate;
        AlphaArg1[1]             = Current;
        AlphaArg2[1]             = TFactor;
        AlphaOp[1]               = Modulate;

        TextureFactor    = (ShaderParam0);

        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}


