//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>
#include <MaterialDecl.fxh>

const bool EffectDeclaration
<
    string Name      = "GF_SpotLight";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "Null";
    bool   NewMaterialUsage = true;
> = true;

technique T0
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = Disable;

        AddressU[0]      = Clamp;
        AddressV[0]      = Clamp;
        
        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend         = InvDestColor;
        DestBlend        = One;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = Disable;

        AddressU[0]      = Clamp;
        AddressV[0]      = Clamp;

        ZWriteEnable     = False;
        AlphaBlendEnable = True;
        SrcBlend         = One;
        DestBlend        = One;
    }
}


