//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Day/Night Shader
//

#include <Common.fxh>
#include <MaterialDecl.fxh>

const bool EffectDeclaration
<
    string Name      = "GF_DayNight";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "GF_TextureAdd";
    bool   NewMaterialUsage = true;
> = true;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = Disable;

        Texture[1]               = (EmissiveTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = AddSmooth;
        AlphaOp[1]               = Disable;

        AlphaBlendEnable         = (State_TextureAlphaBlendEnable);
        SrcBlend                 = SrcAlpha;
        DestBlend                = InvSrcAlpha;

        AlphaTestEnable          = (State_TextureAlphaBlendEnable);
        AlphaFunc                = NotEqual;
        AlphaRef                 = 0x00;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaOp[0]               = SelectArg1;

        FogEnable                = (State_FogEnable);
        AlphaBlendEnable         = False;
    }

    pass P1
    {
        Texture[0]               = (EmissiveTexture);
        ColorArg1[0]             = Texture;
        ColorOp[0]               = SelectArg1;
        AlphaOp[0]               = Disable;

        FogEnable                = False;
        AlphaBlendEnable         = True;
        SrcBlend                 = InvDestColor;
        DestBlend                = One;
    }
}


