//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Day/Night Shader
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "EmissiveMapAdditiveAlpha";
    string Class     = "Basic";
    string Features  = "FixedFunction";
    string Fallback  = "TextureAdd";
> = true;

texture BaseTexture  : TEXTURE0;
texture NightTexture : TEXTURE1;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>
        
        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        Texture[1]               = (NightTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Add;
        AlphaArg1[1]             = Texture;
        AlphaOp[1]               = SelectArg1;

        AlphaBlendEnable         = (State_TextureAlphaBlendEnable);
        SrcBlend                 = SrcAlpha;
        DestBlend                = InvSrcAlpha;

        AlphaTestEnable          = (State_TextureAlphaBlendEnable);
        AlphaFunc                = NotEqual;
        AlphaRef                 = 0x00;
    }
}

technique T1
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        FogEnable                = (State_FogEnable);
        AlphaBlendEnable         = (State_TextureAlphaBlendEnable);
        SrcBlend                 = SrcAlpha;
        DestBlend                = InvSrcAlpha;

        AlphaTestEnable          = (State_TextureAlphaBlendEnable);
        AlphaFunc                = NotEqual;
        AlphaRef                 = 0x00;
    }

    pass P1
    {
        Texture[0]               = (NightTexture);
        ColorArg1[0]             = Texture;
        ColorOp[0]               = SelectArg1;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        FogEnable                = False;
        AlphaBlendEnable         = True;
        SrcBlend                 = One;
        DestBlend                = One;
    }
}


