//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Just copy the base texture
//

#include <Common.fxh>
#include <MaterialDecl.fxh>
#include <D3D9Texture.fxh>
#include <FuncLibrary.fxh>

const bool EffectDeclaration
<
    string Name      = "Black";
    string Class     = "Basic";
    string Fallback  = "Assert";
> = true;

struct VS_OUTPUT
{
    float4 vPos    : POSITION;
};

VS_OUTPUT
VS_GetBlack(const float4 vPos : POSITION)
{
    VS_OUTPUT o;

    o.vPos = mul(vPos, mFullProj);

    return (o);
}

float4
PS_GetBlack() : COLOR
{
    return (float4(0, 0, 0, 0));
}

technique T0
<
>
{
    pass P0
    {
        VertexShader             = compile vs_1_1 VS_GetBlack();
        PixelShader              = compile ps_1_1 PS_GetBlack();
        FogEnable                = False;
        AlphaBlendEnable         = False;
        SrcBlend                 = One;
        DestBlend                = Zero;
	NormalizeNormals         = True;
	ZWriteEnable             = True;
	ZEnable                  = True;
	ZFunc                    = LessEqual;
	SeparateAlphaBlendEnable = False;
	AlphaTestEnable          = False;
	StencilEnable            = False;
	SpecularEnable           = False;
	ColorWriteEnable         = Red | Green | Blue;
	CullMode                 = CCW;
    }
}

