//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Basic aircraft shader
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "AircraftLightMapAlpha";
    string Class     = "Aircraft";
    string Features  = "FixedFunction";
    string Fallback  = "Aircraft";
> = true;

texture BaseTexture : TEXTURE0
<
    string name = "lake.bmp";
>;

texture LightMapTexture : TEXTURE1
<
    string name = "lake.bmp";
>;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (LightMapTexture);
        ColorArg1[0]             = Diffuse;
        ColorArg2[0]             = Texture;
        ColorOp[0]               = BlendTextureAlphaPM;
        AlphaArg1[0]             = Diffuse;
        AlphaOp[0]               = SelectArg1;

        Texture[1]               = (BaseTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Modulate;
        AlphaArg2[1]             = Current;
        AlphaOp[1]               = SelectArg2;

        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}


