//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Basic aircraft shader
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "AircraftLightMap";
    string Class     = "Aircraft";
    string Features  = "FixedFunction";
    string Fallback  = "Aircraft";
> = true;

texture BaseTexture     : TEXTURE0;
texture LightMapTexture : TEXTURE1;

technique T0
<
>
{
    pass P0
    {
        #include <TwoStageDefault.fxh>

        Texture[0]               = (LightMapTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Add;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = SelectArg2;

        Texture[1]               = (BaseTexture);
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = Current;
        ColorOp[1]               = Modulate;
        AlphaArg2[1]             = Current;
        AlphaOp[1]               = SelectArg2;

        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}


