//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// Aircraft reflection shader
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name      = "AircraftEnv";
    string Class     = "Aircraft";
    string Features  = "FixedFunction, Reflect";
    string Fallback  = "Aircraft";
> = true;

texture BaseTexture : TEXTURE0;
texture EnvTexture  : TEXTURE1;

matrix mEnv           : AIRCRAFTENVMATRIX;
dword  GlobalLighting : GLOBALLIGHTING;

technique AircraftEnv
<
>
{
    pass P0
    {
        #include <ThreeStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ResultArg[0]             = Temp;
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;

        Texture[1]               = (EnvTexture);
        AddressU[1]              = Clamp;
        AddressV[1]              = Clamp;
        ColorArg1[1]             = Texture;
        ColorArg2[1]             = TFactor;
        ColorOp[1]               = Modulate;
        AlphaArg1[2]             = Diffuse;
        AlphaOp[1]               = SelectArg2;
        TexCoordIndex[1]         = CameraSpaceReflectionVector;
        TextureTransformFlags[1] = Count2;
        TextureTransform[1]      = (mEnv);

        ColorArg1[2]             = Temp;
        ColorArg2[2]             = Current;
        ColorOp[2]               = ModulateInvAlpha_AddColor;
        AlphaArg1[2]             = Current;
        AlphaArg2[2]             = Diffuse;
        AlphaOp[2]               = SelectArg2;
        TexCoordIndex[2]         = 0;

        TextureFactor    = (GlobalLighting);
        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}

technique AircraftEnvFallback
<
>
{
    pass P0
    {
        #include <OneStageDefault.fxh>

        Texture[0]               = (BaseTexture);
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = Diffuse;
        ColorOp[0]               = Modulate;
        AlphaArg2[0]             = Diffuse;
        AlphaOp[0]               = SelectArg2;

        AlphaBlendEnable = (State_AlphaBlendEnable);
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }

    pass P1
    {
        Texture[0]               = (EnvTexture);
        AddressU[0]              = Clamp;
        AddressV[0]              = Clamp;
        ColorArg1[0]             = Texture;
        ColorArg2[0]             = TFactor;
        ColorOp[0]               = Modulate;
        AlphaArg1[0]             = Texture;
        AlphaOp[0]               = SelectArg1;
        TexCoordIndex[0]         = CameraSpaceReflectionVector;
        TextureTransformFlags[0] = Count2;
        TextureTransform[0]      = (mEnv);

        ColorArg2[1]             = Current;
        ColorOp[1]               = SelectArg2;
        AlphaArg1[1]             = Texture | Complement;
        AlphaOp[1]               = SelectArg1;

        ColorOp[2]               = Disable;
        AlphaOp[2]               = Disable;

        TextureFactor    = (GlobalLighting);
        SpecularEnable   = False;

        AlphaBlendEnable = True;
        SrcBlend	 = SrcAlpha;
        DestBlend	 = InvSrcAlpha;
    }
}

