//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
#ifndef _MATERIALDECL_FXH_
#define _MATERIALDECL_FXH_

texture BaseTexture     : MATERIAL_BASE_TEXTURE < string name = "banana.bmp"; >;
texture DetailTexture   : MATERIAL_DETAIL_TEXTURE < string name = "runway_detail.bmp"; >;
texture BumpTexture     : MATERIAL_BUMP_TEXTURE < string name = "runway_bump.bmp"; >;
texture SpecularTexture : MATERIAL_SPECULAR_TEXTURE < string name = "banana.bmp"; >;
texture EnvTexture      : MATERIAL_ENVIRONMENT_TEXTURE_CUBE < string type = "CUBE"; string name = "GlobalEnvTest.dds"; >;
texture FresnelRamp     : MATERIAL_FRESNEL_RAMP < string name = "FresnelTest.bmp"; >;
texture EmissiveTexture : MATERIAL_EMISSIVE_TEXTURE < string name = "Halo.bmp"; >;
texture ShadowMap		: MATERIAL_SHADOW_MAP < string name = "banana.bmp"; >;

float4  MatScales    : MATERIAL_SCALES    = { 1.0, 1.0, 1.0, 0.0 };
float4  MatSpecular  : MATERIAL_SPECULAR  = { 1.0, 0.8, 0.8, 5.0 };
float4  MatDiffuse   : MATERIAL_DIFFUSE   = { 1.0, 1.0, 1.0, 1.0 };
float4  MatConstants : MATERIAL_CONSTANTS = { 1.0, 1.0, 1.0, 1.0 };

#define BumpScale       MatScales.x
#define DetailScale     MatScales.y
#define EnvLevelScale   MatScales.z
#define SpecularColor   MatSpecular
#define SpecularPower   MatSpecular.a
#define GlobalPrecipLevel    MatConstants.x
#define MatPrecipOffset      MatConstants.y
#define MatSpecMapPowerScale MatConstants.z
#define MatSpecBloomFloor    MatConstants.w

sampler2D BaseSampler = sampler_state
{
    Texture       = (BaseTexture);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

sampler2D DetailSampler = sampler_state
{
    Texture       = (DetailTexture);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

sampler2D BumpSampler = sampler_state
{
    Texture       = (BumpTexture);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = D3DTEXF_LINEAR;
    MagFilter     = D3DTEXF_LINEAR;
    MipFilter     = D3DTEXF_LINEAR;
    MipMapLodBias = (State_MipMapLodBias);
};

sampler2D SpecularSampler = sampler_state
{
    Texture       = (SpecularTexture);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

sampler1D FresnelSampler = sampler_state
{
    Texture       = (FresnelRamp);
    AddressU      = Clamp;
    AddressV      = Clamp;
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

samplerCUBE EnvSampler = sampler_state
{
    Texture       = (EnvTexture);
    AddressU      = Clamp;
    AddressV      = Clamp;
    AddressW      = Clamp;
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

sampler2D EmissiveSampler = sampler_state
{
    Texture       = (EmissiveTexture);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

sampler2D ShadowMapSampler = sampler_state
{
    Texture       = (ShadowMap);
    AddressU      = (State_TextureWrap);
    AddressV      = (State_TextureWrap);
    MinFilter     = (State_MinFilter);
    MagFilter     = (State_MagFilter);
    MipFilter     = (State_MipFilter);
    MipMapLodBias = (State_MipMapLodBias);
};

#endif // _MATERIALDECL_FXH_
