//-----------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation. All Rights Reserved
//-----------------------------------------------------------------------------

#ifndef _FUNCLIBRARY10_FXH_
#define _FUNCLIBRARY10_FXH_

#define HALF_ANGLE_SPECULAR

//
// Calculate specular color.
//
float3
CalculateSpecular10(
    const float3 vEyeDir, 
    const float3 vLight, 
    const float3 vNormal,
    const float  fSpecularPower,
    const float3 vSunDirectional,
    const float3 fSpecularColor
    )
{
    #ifdef HALF_ANGLE_SPECULAR
        // Calculate half angle vector and secular intensity.
        float3 vHN = normalize(vEyeDir + vLight);
        float fSpec = pow(saturate(dot(vNormal, vHN)), fSpecularPower);
    #else
        // Calculate the reflection vector and secular intensity.
        float3 vReflect = 2.0 * dot(vNormal,vLight) * vNormal - vLight;
        float fSpec = pow(saturate(dot(vReflect,vEyeDir)), fSpecularPower);
    #endif

    #if defined(SHD_BLOOM) && !defined(SHD_NOSPECULARBLOOM) 
        fSpec *= fHdrSpecularScale;
    #endif

    // Calculate the specular color.
    float3 cSpecular = fSpec * fSpecularColor * vSunDirectional;

    return cSpecular;
}


//
// Calculate the specular color using a specular map.
//
float3
CalculateSpecularFromMap10(
    const float3 vEyeDir, 
    const float3 vLight, 
    const float3 vNormal, 
    const float4 cSpecularMap,
    const float  fMatSpecMapPowerScale,
    const float3 vSunDirectional
    )
{
    // Bias with the specular power scale.
    float  fPow = cSpecularMap.a * fMatSpecMapPowerScale + 0.0001;

    #ifdef HALF_ANGLE_SPECULAR
        // Calculate half angle vector and secular intensity.
        float3 vHN = normalize(vEyeDir + vLight);
        float fSpec = pow(saturate(dot(vNormal, vHN)), fPow);
    #else
        // Calculate the reflection vector and specular intensity.
        float3 vReflect = 2.0 * dot(vNormal,vLight) * vNormal - vLight;
        float fSpec = pow(saturate(dot(vReflect,vEyeDir)), fPow);
    #endif

    #if defined(SHD_BLOOM) && !defined(SHD_NOSPECULARBLOOM) 
        fSpec *= fHdrSpecularScale;
    #endif

    float3 cSpecular = fSpec * cSpecularMap * vSunDirectional;

    return cSpecular;
}


#endif // _FUNCLIBRARY10_FXH_
