//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// This effect sets up the global device state
//
#include <Common.fxh>

const bool EffectDeclaration
<
    string Name        = "DeviceStateInit";
    string Class       = "Global";
    string OuterEffect = "DefaultStates";
    string Features    = "FixedFunction";
> = true;

technique T0
{
    pass p0
    {
	VertexShader = Null;
	PixelShader  = Null;

	LocalViewer  = True;
	NormalizeNormals = True;
	ZEnable          = True;
	ZWriteEnable     = True;
	ZFunc            = LessEqual;
	ShadeMode        = Gouraud;
	DitherEnable     = True;
	CullMode         = None;
	StencilFunc      = NotEqual;
	StencilRef       = 0x01;
	StencilMask      = 0xffffffff;
	StencilWriteMask = 0xffffffff;
	StencilZFail     = Keep;
	StencilFail      = Keep;
	StencilPass      = Replace;
	FogEnable        = False;
	RangeFogEnable   = False;
	FogTableMode     = None;
	FogVertexMode    = None;
    }
}

