//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
//
// This effect sets up the global state
//

#include <Common.fxh>

const bool EffectDeclaration
<
    string Name        = "DeviceInit";
    string Class       = "Global";
    string Features    = "FixedFunction";
    string OuterEffect = "DeviceStateInit";
> = true;

technique FourTextureStage
{
    pass P0
    {
	VertexShader             = Null;
	PixelShader              = Null;

	Texture[0]               = Null;
	ResultArg[0]             = Current;
	ColorArg1[0]             = Texture;
	ColorArg2[0]             = Current;
	ColorOp[0]               = Disable;
	AlphaArg1[0]             = Texture;
	AlphaArg2[0]             = Current;
	AlphaOp[0]               = Disable;
	TexCoordIndex[0]         = 0;
	TextureTransformFlags[0] = 0;
	AddressU[0]              = (State_TextureWrap);	
	AddressV[0]              = (State_TextureWrap);	
	MinFilter[0]             = (State_MinFilter);
	MagFilter[0]             = (State_MagFilter);
	MipFilter[0]             = (State_MipFilter);
	MipMapLodBias[0]         = (State_MipMapLodBias);
	BorderColor[0]           = 0;

	Texture[1]               = Null;
	ResultArg[1]             = Current;
	ColorArg1[1]             = Texture;
	ColorArg2[1]             = Current;
	ColorOp[1]               = Disable;
	AlphaArg1[1]             = Texture;
	AlphaArg2[1]             = Current;
	AlphaOp[1]               = Disable;
	TexCoordIndex[1]         = 0;
	TextureTransformFlags[1] = 0;
	AddressU[1]              = Wrap;
	AddressV[1]              = Wrap;
	MinFilter[1]             = (State_MinFilter);
	MagFilter[1]             = (State_MagFilter);
	MipFilter[1]             = (State_MipFilter);
	MipMapLodBias[1]         = (State_MipMapLodBias);
	BorderColor[1]           = 0;

	Texture[2]               = Null;
	ResultArg[2]             = Current;
	ColorArg1[2]             = Texture;
	ColorArg2[2]             = Current;
	ColorOp[2]               = Disable;
	AlphaArg1[2]             = Texture;
	AlphaArg2[2]             = Current;
	AlphaOp[2]               = Disable;
	TexCoordIndex[2]         = 0;
	TextureTransformFlags[2] = 0;
	AddressU[2]              = Wrap;
	AddressV[2]              = Wrap;
	MinFilter[2]             = (State_MinFilter);
	MagFilter[2]             = (State_MagFilter);
	MipFilter[2]             = (State_MipFilter);
	MipMapLodBias[2]         = (State_MipMapLodBias);
	BorderColor[2]           = 0;

	Texture[3]               = Null;
	ResultArg[3]             = Current;
	ColorArg1[3]             = Texture;
	ColorArg2[3]             = Current;
	ColorOp[3]               = Disable;
	AlphaArg1[3]             = Texture;
	AlphaArg2[3]             = Current;
	AlphaOp[3]               = Disable;
	TexCoordIndex[3]         = 0;
	TextureTransformFlags[3] = 0;
	AddressU[3]              = Wrap;
	AddressV[3]              = Wrap;
	MinFilter[3]             = (State_MinFilter);
	MagFilter[3]             = (State_MagFilter);
	MipFilter[3]             = (State_MipFilter);
	MipMapLodBias[3]         = (State_MipMapLodBias);
	BorderColor[3]           = 0;
    }
}

technique ThreeTextureStage
{
    pass P0
    {
	VertexShader             = Null;
	PixelShader              = Null;

	Texture[0]               = Null;
	ResultArg[0]             = Current;
	ColorArg1[0]             = Texture;
	ColorArg2[0]             = Diffuse;
	ColorOp[0]               = Disable;
	AlphaArg1[0]             = Texture;
	AlphaArg2[0]             = Diffuse;
	AlphaOp[0]               = Disable;
	TexCoordIndex[0]         = 0;
	TextureTransformFlags[0] = 0;
	AddressU[0]              = (State_TextureWrap);	
	AddressV[0]              = (State_TextureWrap);	
	MinFilter[0]             = (State_MinFilter);
	MagFilter[0]             = (State_MagFilter);
	MipFilter[0]             = (State_MipFilter);
	MipMapLodBias[0]         = (State_MipMapLodBias);
	BorderColor[0]           = 0;

	Texture[1]               = Null;
	ResultArg[1]             = Current;
	ColorArg1[1]             = Texture;
	ColorArg2[1]             = Current;
	ColorOp[1]               = Disable;
	AlphaArg1[1]             = Texture;
	AlphaArg2[1]             = Current;
	AlphaOp[1]               = Disable;
	TexCoordIndex[1]         = 0;
	TextureTransformFlags[1] = 0;
	AddressU[1]              = Wrap;
	AddressV[1]              = Wrap;
	MinFilter[1]             = (State_MinFilter);
	MagFilter[1]             = (State_MagFilter);
	MipFilter[1]             = (State_MipFilter);
	MipMapLodBias[1]         = (State_MipMapLodBias);
	BorderColor[1]           = 0;

	Texture[2]               = Null;
	ResultArg[2]             = Current;
	ColorArg1[2]             = Texture;
	ColorArg2[2]             = Current;
	ColorOp[2]               = Disable;
	AlphaArg1[2]             = Texture;
	AlphaArg2[2]             = Current;
	AlphaOp[2]               = Disable;
	TexCoordIndex[2]         = 0;
	TextureTransformFlags[2] = 0;
	AddressU[2]              = Wrap;
	AddressV[2]              = Wrap;
	MinFilter[2]             = (State_MinFilter);
	MagFilter[2]             = (State_MagFilter);
	MipFilter[2]             = (State_MipFilter);
	MipMapLodBias[2]         = (State_MipMapLodBias);
	BorderColor[2]           = 0;
    }
}

technique TwoTextureStage
{
    pass P0
    {
	VertexShader             = Null;
	PixelShader              = Null;

	Texture[0]               = Null;
	ResultArg[0]             = Current;
	ColorArg1[0]             = Texture;
	ColorArg2[0]             = Diffuse;
	ColorOp[0]               = Disable;
	AlphaArg1[0]             = Texture;
	AlphaArg2[0]             = Diffuse;
	AlphaOp[0]               = Disable;
	TexCoordIndex[0]         = 0;
	TextureTransformFlags[0] = 0;
	AddressU[0]              = (State_TextureWrap);	
	AddressV[0]              = (State_TextureWrap);	
	MinFilter[0]             = (State_MinFilter);
	MagFilter[0]             = (State_MagFilter);
	MipFilter[0]             = (State_MipFilter);
	MipMapLodBias[0]         = (State_MipMapLodBias);
	BorderColor[0]           = 0;

	Texture[1]               = Null;
	ResultArg[1]             = Current;
	ColorArg1[1]             = Texture;
	ColorArg2[1]             = Current;
	ColorOp[1]               = Disable;
	AlphaArg1[1]             = Texture;
	AlphaArg2[1]             = Current;
	AlphaOp[1]               = Disable;
	TexCoordIndex[1]         = 0;
	TextureTransformFlags[1] = 0;
	AddressU[1]              = Wrap;
	AddressV[1]              = Wrap;
	MinFilter[1]             = (State_MinFilter);
	MagFilter[1]             = (State_MagFilter);
	MipFilter[1]             = (State_MipFilter);
	MipMapLodBias[1]         = (State_MipMapLodBias);
	BorderColor[1]           = 0;
    }
}

technique OneTextureStage
{
    pass P0
    {
	VertexShader             = Null;
	PixelShader              = Null;

	Texture[0]               = Null;
	ResultArg[0]             = Current;
	ColorArg1[0]             = Texture;
	ColorArg2[0]             = Diffuse;
	ColorOp[0]               = Disable;
	AlphaArg1[0]             = Texture;
	AlphaArg2[0]             = Diffuse;
	AlphaOp[0]               = Disable;
	TexCoordIndex[0]         = 0;
	TextureTransformFlags[0] = 0;
	AddressU[0]              = (State_TextureWrap);	
	AddressV[0]              = (State_TextureWrap);	
	MinFilter[0]             = (State_MinFilter);
	MagFilter[0]             = (State_MagFilter);
	MipFilter[0]             = (State_MipFilter);
	MipMapLodBias[0]         = (State_MipMapLodBias);
	BorderColor[0]           = 0;
    }
}
