//---------------------------------------------------------------------------
// Flight Simulator X - Shader Effect Files
// Copyright (c) 2006, Microsoft Corporation
//---------------------------------------------------------------------------
#ifndef _COMMON_FXH_
#define _COMMON_FXH_

#define TRUE  1
#define FALSE 0

#define D3DCMP_LESSEQUAL 4
#define D3DTADDRESS_WRAP 1

#define MAX_BONES  22

#define MAX_POINT_LIGHTS 5

#define D3DTEXF_NONE          0
#define D3DTEXF_POINT         1
#define D3DTEXF_LINEAR        2
#define D3DTEXF_ANISOTROPIC   3
#define D3DTEXF_PYRAMIDALQUAD 6
#define D3DTEXF_GAUSSIANQUAD  7

bool  State_AlphaBlendEnable         : STATE_ALPHABLENDENABLE         = false;
bool  State_ShadowAlphaBlendEnable   : STATE_SHADOWALPHABLENDENABLE   = false;
bool  State_TextureAlphaBlendEnable  : STATE_TEXTUREALPHABLENDENABLE  = false;
bool  State_FallbackAlphaBlendEnable : STATE_FALLBACKALPHABLENDENABLE = false;
bool  State_FogEnable                : STATE_FOGENABLE                = true;
bool  State_ZWriteEnable             : STATE_ZWRITEENABLE             = true;
dword State_ColorWriteEnable         : STATE_COLORWRITEENABLE;
dword State_ZFunc                    : STATE_ZFUNC                    = D3DCMP_LESSEQUAL;
bool  State_SpecularEnable           : STATE_SPECULARENABLE           = false;
bool  State_StencilEnable            : STATE_STENCILENABLE            = false;
dword State_TextureWrap              : STATE_TEXTUREWRAP              = D3DTADDRESS_WRAP;
dword State_MinFilter                : STATE_MINFILTER                = D3DTEXF_LINEAR;
dword State_MagFilter                : STATE_MAGFILTER                = D3DTEXF_LINEAR;
dword State_MipFilter                : STATE_MIPFILTER                = D3DTEXF_LINEAR;
dword State_MipMapLodBias            : STATE_MIPMAPLODBIAS            = 0;
dword State_SrcBlend                 : STATE_SRCBLEND                 = 2;
dword State_DstBlend                 : STATE_DSTBLEND                 = 1;
dword State_CullMode                 : STATE_CULLMODE                 = 3;
bool  State_AlphaTestEnable          : STATE_ALPHATESTENABLE          = false;
dword State_AlphaTestFunction        : STATE_ALPHATESTFUNCTION        = D3DCMP_LESSEQUAL;
dword State_AlphaTestThreshold       : STATE_ALPHATESTTHRESHOLDBYTE   = 255;
float State_FinalAlphaBlendFactor    : STATE_FINALALPHABLENDFACTOR    = 1.0;
float State_BlendedEmissiveFactor    : STATE_BLENDEDEMISSIVEFACTOR    = 1.0;
float4 State_BlendConstant           : STATE_BLENDCONSTANT;

dword ShaderParam0                   : SHADERPARAM0                   = 0;
dword ShaderParam1                   : SHADERPARAM1                   = 0;
dword ShaderParam2                   : SHADERPARAM2                   = 0;
dword ShaderParam3                   : SHADERPARAM3                   = 0;
dword ShaderParam4                   : SHADERPARAM4                   = 0;
dword ShaderParam5                   : SHADERPARAM5                   = 0;
dword ShaderParam6                   : SHADERPARAM6                   = 0;
dword ShaderParam7                   : SHADERPARAM7                   = 0;
dword ShaderParam8                   : SHADERPARAM8                   = 0;
dword ShaderParam9                   : SHADERPARAM9                   = 0;
dword ShaderParam10                  : SHADERPARAM10                  = 0;
dword ShaderParam11                  : SHADERPARAM11                  = 0;
dword ShaderParam12                  : SHADERPARAM12                  = 0;
dword ShaderParam13                  : SHADERPARAM13                  = 0;
dword ShaderParam14                  : SHADERPARAM14                  = 0;

float ShaderFloatParam0              : SHADERFLOATPARAM0              = 0;
float ShaderFloatParam1              : SHADERFLOATPARAM1              = 0;
float ShaderFloatParam2              : SHADERFLOATPARAM2              = 0;
float ShaderFloatParam3              : SHADERFLOATPARAM3              = 0;
float ShaderFloatParam4              : SHADERFLOATPARAM4              = 0;
float ShaderFloatParam5              : SHADERFLOATPARAM5              = 0;
float ShaderFloatParam6              : SHADERFLOATPARAM6              = 0;
float ShaderFloatParam7              : SHADERFLOATPARAM7              = 0;
float ShaderFloatParam8              : SHADERFLOATPARAM8              = 0;
float ShaderFloatParam9              : SHADERFLOATPARAM9              = 0;
float ShaderFloatParam10             : SHADERFLOATPARAM10             = 0;
float ShaderFloatParam11             : SHADERFLOATPARAM11             = 0;
float ShaderFloatParam12             : SHADERFLOATPARAM12             = 0;
float ShaderFloatParam13             : SHADERFLOATPARAM13             = 0;
float ShaderFloatParam14             : SHADERFLOATPARAM14             = 0;
float ShaderFloatParam15             : SHADERFLOATPARAM15             = 0;

matrix mWorld            : WORLD;
matrix mWorldView        : WORLDVIEW;
matrix mWorldInv         : WORLD_INVERSE;
matrix mView             : VIEW;
matrix mProjection       : PROJECTION;
matrix mFullProj         : WORLDVIEWPROJECTION;
matrix mShadowMtx        : SHADOWPROJECTION;
matrix mShadowViewMtx    : SHADOWVIEW;
float4 vShadowOffset     : SHADOWOFFSET;
float  fShadowRange      : SHADOWRANGE;
float  fShadowKickIn     : SHADOWKICKIN;
float  fShadowIntensity  : SHADOWINTENSITY;
float  fShadowBias       : SHADOWBIAS;

// Skinning bone refs
float4x3 mBones[MAX_BONES] : BONE_MATRIX;

// Fog
float4 g_FogConstants : FOGCONSTANTS;

// Time
float  fSimTime  : SIMTIME;

#define FOG_END          g_FogConstants.x
#define FOG_RECIP        g_FogConstants.y
#define FOG_SELECT_VERTEX g_FogConstants.z
#define FOG_SELECT_TABLE  g_FogConstants.w

#define EffectPerfLevel_Min          0
#define EffectPerfLevel_MaxNonShader 9
#define EffectPerfLevel_Shader11     10
#define EffectPerfLevel_MaxShader11  19
#define EffectPerfLevel_Shader20     20
#define EffectPerfLevel_MaxShader20  29
#define EffectPerfLevel_Shader30     30
#define EffectPerfLevel_MaxShader30  39

float3 vSunVectorObject : SUNVECTOR_OBJECTSPACE
<
    string UIDirectional = "Light Object";
> = {0, 0, 1};

float3 vSunVectorWorld  : SUNVECTOR_WORLDSPACE
<
    string UIDirectional = "Light Direction";
> = {0.577, -0.577, 0.577};

float3 vSunVectorObject_Sun     : LIGHTVECTOR_SUN_OBJECTSPACE;
float3 vSunVectorWorld_Sun      : LIGHTVECTOR_SUN_WORLDSPACE;
float3 vSunVectorObject_Moon    : LIGHTVECTOR_MOON_OBJECTSPACE;
float3 vSunVectorWorld_Moon     : LIGHTVECTOR_MOON_WORLDSPACE;

float3 vSunAmbient              : SUNCOLOR_AMBIENT     = {0.1, 0.1, 0.1};
float3 vSunDirectional          : SUNCOLOR_DIRECTIONAL = {0.9, 0.9, 1.0};
float4 vEyePoint                : VIEWPOSITION;
float  fSunMoonInterpolant      : SUNMOON_INTERPOLANT;

// Point lights data
int iPointLightCount                            : POINTLIGHT_COUNT;
float3 vPointLightWorldSpace[MAX_POINT_LIGHTS]  : POINTLIGHTVECTOR_WORLDSPACE;
float3 vPointLightDiffuse[MAX_POINT_LIGHTS]     : POINTLIGHTCOLOR_DIFFUSE;
float3 vPointLightSpecular[MAX_POINT_LIGHTS]    : POINTLIGHTCOLOR_SPECULAR;

// Range attenuation is stored as: Range, A0, A1, A2 coefficients
float4 vPointLightRangeAttenuation[MAX_POINT_LIGHTS] : POINTLIGHTVECTOR_RANGE_ATTENUATION;

// A light which illuminates objects at 80 lum/sr should be drawn
// at 3183 lumens/meter^2/steradian, which equates to a multiplier
// of 39.78 per lumen.

float g_fEmissiveCoefficient : HDR_EMISSIVE_SCALAR = 39.78f;

#endif // _COMMON_FXH_
